<?LassoScript 
	/*
			Check for this user's administrator status.
		The user is an administrator if they are in either the regular
		'administrators' group or in the 'OP Message Board Admins' group.
	*/
	
	var('isLoggedIn' = admin_currentusername != 'ANONYMOUS' && admin_currentusername->size > 0);
	var('isAdmin' = admin_currentgroups >> 'OP Message Board Admins' || admin_currentgroups >> 'administrators');
		
	/*
			Are we trying to authenticate?
	*/
	if (!$isLoggedIn && action_param('auth')->size > 0);
		// this will cause the authentication dialog to come up if the user is not yet logged in
		auth;
	/if;
	
	/*
			Start the session that we use for tracking a few personal settings such 
		as number of replies to show per page.	
		
			Initialize all session variables here.
	*/
	session_start(-name=Application_appInfo->title);
	session_addVar(-name=Application_appInfo->title, 'max');
	!var_defined('max') ? var('max'=5);
	action_param('max') ? $max = (action_param('max') == 'all' ? 'all' | integer(action_param('max')));

	/*
			Initialize the databases and groups which are required for the
		message board. The database structure is as follows:
	
		op_message_board
		forum_groups
			id
			position - controls the ordering when groups are listed
			title - the name of the group
		forums
			id
			id_group - the id of the group the forum is in
			position - controls the ordering when forums are listed
			title - the name of the forum
			description - the description for the forum
		messages
			id
			id_forum - the id of the forum the message is in
			id_reply - the id of the message that this is in reply to, if any
			id_author - the id of the message's author
			date - the date the message was posted
			title - the title of the message
			body - the body text for the message
		authors
			id
			name - the name of the author
			avatar - the user's avatar image as a BLOB
			avatar_type - the content type of the character's image
	
	*/
	local('initializeResults' = Application_initialize(
													Application_appInfo->title, 
													Application_appInfo->version, 
													array(
			-group = pair('OP Message Board Admins'='Users which are allowed to administer the message board system.'),
			-database = pair('op_message_board'= array(
			
				-group = pair('ANYUSER'='I,S,A,U,D,X'),
				-table = pair('forum_groups'= array(
					-sql = 'CREATE TABLE forum_groups (	id INTEGER PRIMARY KEY, 
														position INTEGER, 
														title TEXT)',
					-group = pair('ANYUSER'='I,S,A,U,D,X')
					)),
				-table = pair('forums'= array(
					-sql = 'CREATE TABLE forums (	id INTEGER PRIMARY KEY, 
													id_group INTEGER, ' // needs index?
													'position INTEGER, 
													title TEXT, 
													description TEXT)',
					-sql='CREATE INDEX forums_id_group_index ON forums (id_group)',
					-group = pair('ANYUSER'='I,S,A,U,D,X')
					)),
				-table = pair('messages'= array(
					-sql = 'CREATE TABLE messages (	id INTEGER PRIMARY KEY, 
													id_forum INTEGER,' // needs index
													'id_reply INTEGER,' // needs index 
													'id_author INTEGER,' // needs index 
													'date TEXT DEFAULT CURRENT_TIMESTAMP,
													title TEXT, 
													body TEXT)',
					-sql = 'CREATE INDEX messages_id_forum_index ON messages (id_forum)',
					-sql = 'CREATE INDEX messages_id_reply_index ON messages (id_reply)',
					-sql = 'CREATE INDEX messages_id_author_index ON messages (id_author)',
					-group = pair('ANYUSER'='I,S,A,U,D,X')
					)),
				-table = pair('authors'= array(
					-sql = 'CREATE TABLE authors (	id INTEGER PRIMARY KEY, 
													name TEXT,' // needs index 
													'avatar BLOB, 
													avatar_type TEXT)',
					-sql = 'CREATE INDEX authors_name_index ON authors (name)',
					-group = pair('ANYUSER'='I,S,A,U,D,X')
					))
				))
			)));
		
	// if the application was just now initialized, add a starter group, forum and message
	if (#initializeResults->size);
		inline(-database='op_message_board');
			inline(-table='forum_groups', -findall);
				if (found_count == 0);
					inline(-sql="INSERT INTO forum_groups (id, position, title) VALUES (1, 0, \'Forums\');"
								"INSERT INTO forums (id_group, position, title, description) VALUES (1, 0, \'Main Forum\', \'This is the default forum.\');"
								"INSERT INTO authors (id, name) VALUES (1, 'administrator');"
								"INSERT INTO messages (id_forum, id_author, title, body) VALUES (1, 1, 'Welcome!', '\
									Welcome to the Lasso Message Board!\r\n\
									Your new message board was successfully initialized.\
								')");/inline;
				/if;
			/inline;
		/inline;
	/if;
	
	/*
			This tag will lookup a message author by id and return its name. It
		creates and keeps a page level variable to avoid looking up the same
		author repeatedly.
			
			It will return null if the author was not found.
	*/
	define_tag('findAuthorById', -namespace='MessageBoard_', -required='id');
		if (!var_defined('MessageBoard_authorMap'));
			var('MessageBoard_authorMap' = map);
		/if;
		local('fnd' = $MessageBoard_authorMap->find(#id));
		if (#fnd == null);
			inline(-database='op_message_board', -table='authors', -search, 
					-op='eq', 'id'=#id, -returnField='name');
				if (found_count);
					#fnd = field('name');
					$MessageBoard_authorMap->insert(#id = #fnd);
				/if;
			/inline;
		/if;
		return: #fnd;
	/define_tag;
	
	/*
			This tag will return the id of the specified author. If the author 
		is not in the database, it will be added and the new id returned.
	*/
	define_tag('findAuthorByName', -namespace='MessageBoard_', -required='name');
		inline(-database='op_message_board', -table='authors', -op='eq', 'name'=#name, -search, -returnField='id');
			if (found_count == 0);
				inline(-add, 'name'=#name);
					return: recordid_value;
				/inline;
			else;
				return: integer(field('id'));
			/if;
		/inline;
	/define_tag;
?>